//
//  MCExportRule.h
//  MCClientServer
//
//  Created by Brent Gulanowski on 17/06/08.
//  Copyright 2008 Marketcircle, Inc. All rights reserved.
//

#import <Foundation/Foundation.h>


extern NSString *kMCExportEntityIDColumnName;
extern NSString *kMCExportIsPrimaryColumnName;

extern NSString *kMCExportSubUsernameToken;

extern NSString *kMCExportQualifierCutoffDateToken;
extern NSString *kMCExportQualifierCurrentYearToken;
extern NSString *kMCExportQualifierUserContactToken;
extern NSString *kMCExportQualifierUserContactIDToken;
extern NSString *kMCExportQualifierOrganizationSyncListIDToken;
extern NSString *kMCExportQualifierContactSyncListIDToken;


typedef enum {
	MCExportRuleQueryTypeUndefined = 0,
	MCExportRuleQueryTypeRelationship,
	MCExportRuleQueryTypeCommonAttribute,
	MCExportRuleQueryTypeIntersection,
	MCExportRuleQueryTypeLimited
} MCExportRuleQueryType;


@class BDQualifier, MCExportRule;

@interface MCExportRuleQuery : NSObject {
	
	MCExportRule *dependentRule; // weak
	MCExportRuleQueryType queryType;
	BDQualifier *qualifier;
	NSString *keyPath;
	NSString *reverseKeyPath;
	NSString *sourceAttribute;
	NSString *destinationAttribute;
	BOOL primaryOnly;
	unsigned resultLimit;
	NSString *sortAttribute;
}

+ (NSString *)nameForType:(MCExportRuleQueryType)type;

- (MCExportRule *)dependentRule;
- (void)setDependentRule:(MCExportRule *)otherRule;
- (MCExportRuleQueryType)queryType;
- (void)setQueryType:(MCExportRuleQueryType)aType;
- (BDQualifier *)qualifier;
- (void)setQualifier:(BDQualifier *)aQualifier;
- (NSString *)keyPath;
- (void)setKeyPath:(NSString *)newKeyPath;
- (NSString *)reverseKeyPath;
- (void)setReverseKeyPath:(NSString *)newKeyPath;
- (NSString *)sourceAttribute;
- (void)setSourceAttribute:(NSString *)newSourceAttribute;
- (NSString *)destinationAttribute;
- (void)setDestinationAttribute:(NSString *)newDestinationAttribute;
- (BOOL)primaryOnly;
- (void)setPrimaryOnly:(BOOL)flag;
- (unsigned)resultLimit;
- (void)setResultLimit:(unsigned)newResultLimit;
- (NSString *)sortAttribute;
- (void)setSortAttribute:(NSString *)newSortAttribute;

- (id)initWithPropertyList:(NSDictionary *)plist qualifierBindings:(NSDictionary *)bindings;
- (NSDictionary *)propertyList;

@end


@class MCPEntity,MCPModel;

@interface MCExportRule : NSObject {

	NSString *name;
	MCPEntity *entity; // weak
	NSString *viewName;
	NSArray *queries;
	BOOL userOwnedFirst; // best name I can come up with so far
	BOOL addAsPrimary; // if this is true, entity must support it

	BDQualifier *qualifier;
	BOOL qualifyQueries; // append the qualifier to the qualifiers in all queries
}

// ruleName usually matches entityName, but it shouldn't have to
- (NSString *)name;
- (void)setName:(NSString *)aName;
- (MCPEntity *)entity;
- (void)setEntity:(MCPEntity *)anEntity;
- (NSString *)viewName;
- (void)setViewName:(NSString *)aViewName;
- (BDQualifier *)qualifier;
- (void)setQualifier:(BDQualifier *)aQualifier;
- (BOOL)qualifyQueries;
- (void)setQualifyQueries:(BOOL)doQualify;
- (NSArray *)queries;
- (void)setQueries:(NSArray *)aQueries;
// if userOwnedFirst == YES, the first independent query will automatically include a qualifier
// such that the objects must be owned by the user; otherwise, all objects are brought over
// (unless there are other qualifiers explicitly specified)
- (BOOL)userOwnedFirst;
- (void)setUserOwnedFirst:(BOOL)flag;
- (BOOL)addAsPrimary;
- (void)setAddAsPrimary:(BOOL)flag;

- (MCExportRuleQuery *)intersectionQuery;
- (NSArray *)unionQueries; // Relationship and CommonAttribute query types are combined

- (id)initWithModel:(MCPModel *)model name:(NSString *)aName propertyList:(NSDictionary *)plist qualifierBindings:(NSDictionary *)bindings;
- (NSDictionary *)propertyList;

@end
